<?php
/**
*
* @package phpBB Extension - RH Topic Tags
* @copyright (c) 2014 Robet Heim
* @license http://opensource.org/licenses/gpl-2.0.php GNU General Public License v2
*
*/

if (!defined('IN_PHPBB'))
{
    exit;
}

if (empty($lang) || !is_array($lang))
{
    $lang = array();
}

// these will be re-used in the definitions below - that is why we need to define and merge them first.
$lang = array_merge($lang, array(
	'ACP_RH_TOPICTAGS_REGEX_DEFAULT'				=> '/^[\- a-z0-9]{3,30}$/i',
	'ACP_RH_TOPICTAGS_REGEX_EXP_FOR_USERS_DEFAULT'	=> '-, 0-9, a-z, A-Z, пробелы (будут конвертированы -), мин: 3, макс: 30',
));

$lang = array_merge($lang, array(
	// forum settings page
	'ACP_RH_TOPICTAGS_ENABLE'								=> 'Включить RH Topic Tags',
	'ACP_RH_TOPICTAGS_ENABLE_EXP'							=> 'Включение/отключение тегов для этого форума. (При отключении этой опции теги не удаляются из сообщений - поэтому, когда вы снова их включите, они будут отображаться; Если вы хотите удалить теги, вам следует использовать опцию "Удалить теги  из этого форумов". )',
	'ACP_FORUM_SETTINGS_RH_TOPICTAGS_PRUNE'					=> 'Удалить теги  из этого форумов',
	'ACP_FORUM_SETTINGS_RH_TOPICTAGS_PRUNE_EXP'				=> 'Будут удалены все теги для тем этого форума.<br/>ПРИМЕЧАНИЕ: Для предотвращения случайного удаления тегов, необходимо сначала отключить теги для этого форума.',
	'ACP_FORUM_SETTINGS_RH_TOPICTAGS_PRUNE_CONFIRM'			=> 'Опция удалит все теги из тема этого форума, для выполнения действия вы должны отключить теги для этого форума.',
	'ACP_RH_TOPICTAGS_PRUNING_REQUIRES_TAGGING_DISABLED'	=> 'Для предотвращения случайного удаления тегов, необходимо отключить теги для этого форума, только после этого вы сможете удалить заданные теги.',

	// config
	'TOPICTAGS_INSTALLED'					=> 'Установленная версия: v%s',

	'ACP_RH_TOPICTAGS_REGEX_EMPTY'			=> 'Регулярное выражение не может быть пустым.',
	'ACP_RH_TOPICTAGS_EXP_FOR_USERS_EMPTY'	=> 'Объяснение, какие теги нельзя оставлять пустыми.',

	'TOPICTAGS_CONFIG'					=> 'Конфигурация',
	'TOPICTAGS_CONFIG_TAGCLOUD'			=> 'Настройки облака тегов',
	'TOPICTAGS_CONFIG_TAGS'				=> 'Настройки тегов',
	'TOPICTAGS_MAINTENANCE'				=> 'Техобслуживание',
	'TOPICTAGS_TITLE'					=> 'RH Topic Tags',
	'TOPICTAGS_SETTINGS_SAVED'			=> 'Конфигурация успешно обновлена.',

	'TOPICTAGS_DISPLAY_TAGCLOUD_ON_INDEX'		=> 'Отображать облако тегов на главной странице списка форумов',
	'TOPICTAGS_DISPLAY_TAGCLOUD_ON_INDEX_EXP'	=> 'Когда включено, облаго тегов отображается внизу главной страницы списка форумов.',

	'TOPICTAGS_DISPLAY_TAGCOUNT_IN_TAGCLOUD'		=> 'Отображать счетчик тегов для каждого тега в облаке',
	'TOPICTAGS_DISPLAY_TAGCOUNT_IN_TAGCLOUD_EXP'	=> 'Когда включено, для каждого тега отображается счетчик - количество тем с данным тегом.',

	'TOPICTAGS_MAX_TAGS_IN_TAGCLOUD'			=> 'Максимальное количество тегов в облаке',
	'TOPICTAGS_MAX_TAGS_IN_TAGCLOUD_EXP'		=> 'Ограничение количества тегов, отображаемых в облаке согласно установленному значению.',

	'TOPICTAGS_DISPLAY_TAGS_IN_VIEWFORUM'		=> 'Отображать теги в списке тем',
	'TOPICTAGS_DISPLAY_TAGS_IN_VIEWFORUM_EXP'	=> 'Если установлено "Да", теги для каждой темы будут отображаться в списке тем.',

	'TOPICTAGS_ENABLE_IN_ALL_FORUMS_ALREADY'	=> 'Теги уже активированы для всех форумов.',
	'TOPICTAGS_ENABLE_IN_ALL_FORUMS'			=> 'Включить теги для всех форумов',
	'TOPICTAGS_ENABLE_IN_ALL_FORUMS_EXP'		=> 'Включение тегов для <em>всех</em> форумов. Впоследствии Вы сможете включить (выключить) отображение тегов в настройках отдельного форума.',
	'TOPICTAGS_ENABLE_IN_ALL_FORUMS_DONE'	=> array(
			1 => 'Теги были включены для %d форума.',
			2 => 'Теги были включены для %d форумов.',
	),

	'TOPICTAGS_DISABLE_IN_ALL_FORUMS_ALREADY'	=> 'Теги отключены для всех форумов.',
	'TOPICTAGS_DISABLE_IN_ALL_FORUMS'			=> 'Отключить теги для всех форумов',
	'TOPICTAGS_DISABLE_IN_ALL_FORUMS_EXP'		=> 'Отключение тегов для <em>всех</em> форумов. Впоследствии Вы сможете включить (выключить) отображение тегов в настройках отдельного форума.',
	'TOPICTAGS_DISABLE_IN_ALL_FORUMS_DONE'	=> array(
			1 => 'Теги были отключены для %d форума.',
			2 => 'Теги были отключены для %d форумов.',
	),

	'TOPICTAGS_PRUNE'					=> 'Удалить неиспользуемые теги',
	'TOPICTAGS_PRUNE_EXP'				=> 'Удаление всех тегов, которые не используются ни в одной теме',
	'TOPICTAGS_PRUNE_CONFIRM'			=> 'Опция позволяет удалить все неиспользуемые теги.',
	'TOPICTAGS_PRUNE_ASSIGNMENTS_DONE'	=> array(
			0 => '',
			1 => '%d тег удален.',
			2 => '%d теги удалены.',
	),
	'TOPICTAGS_PRUNE_TAGS_DONE'			=> array(
			0 => 'Неиспользуемые теги найдены не были.',
			1 => '%d неиспользуемый тег был удален.',
			2 => '%d неиспользуемые теги были удалены.',
	),

	'TOPICTAGS_PRUNE_FORUMS'			=> 'Удалить теги в форумах с отключеными тегами',
	'TOPICTAGS_PRUNE_FORUMS_EXP'		=> 'Удаление всех тегов в темах из форумов с отключенным отображением тегов.',
	'TOPICTAGS_PRUNE_FORUMS_CONFIRM'	=> 'Это действие приведет к удалению всех тегов в темах из форумов с отключенным отображением тегов.',

	'TOPICTAGS_PRUNE_INVALID_TAGS'				=> 'Удалить недействительные теги',
	'TOPICTAGS_PRUNE_INVALID_TAGS_EXP'			=> 'Удаление всех недействительных тегов. Это требуется только если вы изменили регулярное выражение и хотите избавиться от некорректных тегов.',
	'TOPICTAGS_PRUNE_INVALID_TAGS_CONFIRM'		=> 'Это действие удалит все теги, которые не соответвуют установленным регулярным выражениям и может удалить полезные теги, если вы не будете предельно осторожны!',

	'TOPICTAGS_CALC_COUNT_TAGS'					=> 'Пересчитать счетчики тегов',
	'TOPICTAGS_CALC_COUNT_TAGS_EXP'				=> 'Пересчет количества тем, в которых используется каждый тег.',
	'TOPICTAGS_CALC_COUNT_TAGS_DONE'			=> 'Счетчики тегов пересчитаны.',

	'TOPICTAGS_ENABLE_WHITELIST'				=> 'Включить белый список',
	'TOPICTAGS_ENABLE_WHITELIST_EXP'			=> 'Если включено, то разрешаются только теги, которые соответствуют регулярным выражениям и присутствуют в белом списке ниже<br/>ПРИМЕЧАНИЕ 1: Если включен черный список и тэг находится одновременно в белом и в черном списках, он будет отклонен.<br/>ПРИМЕЧАНИЕ 2: Чтобы предотвратить случайную потерю данных, теги, которые уже были в базе данных, но отсутсвуют в белом списке при его включении, не удаляются автоматически и будет по прежнему отображаться. Вы должны удалить их вручную из каждой темы.',

	'TOPICTAGS_WHITELIST'						=> 'Белый список',
	'TOPICTAGS_WHITELIST_EXP'					=> 'Запятая (,) разделяет список разрешенных тегов.<br/>ВНИМАНИЕ: Теги должны  соответствовать регулярным выражениям, поэтому убедитесь, что все перечисленные здесь теги соответствуют настройкам ваших регулярных выражений, приведенных ниже (не проверяется автоматически).',

	'TOPICTAGS_ENABLE_BLACKLIST'				=> 'Включить черный список',
	'TOPICTAGS_ENABLE_BLACKLIST_EXP'			=> 'Если включено, теги из черного списка, будут отклонены, даже если они соответствуют регулярным выражениям.<br/>ПРИМЕЧАНИЕ 1: Чтобы предотвратить случайную потерю данных, теги, которые уже были в базе данных, не удаляются автоматически. Вы должны удалить их вручную из каждой темы.<br/>ПРИМЕЧАНИЕ 2: Черный список никогда не отображается для пользователей.',

	'TOPICTAGS_BLACKLIST'						=> 'Черный список',
	'TOPICTAGS_BLACKLIST_EXP'					=> 'Запятая (,) разделяет список запрещенных тегов.<br/>ВНИМАНИЕ: Все теги, не соответствующие регулярным выражениям всегда отклоняются.',

	'TOPICTAGS_ALLOWED_TAGS_REGEX'				=> 'Регулярное выражение для разрешенных тегов',
	'TOPICTAGS_ALLOWED_TAGS_REGEX_EXP'			=> 'ВНИМАНИЕ: Не изменяйте значение, если вы не уверены в своих действиях. <strong>Теги могуть состоять максимум из 30 символов</strong>, учитывайте это.<br/>Обратите внимание, что после изменения регулярных выражений недействительные теги по-прежнему будут отображаться в темах, но исключаются из поиска по тегам.<br/>Рассмотрим удаление неправильных тегов (см. секцию техобслуживания).<br/>По-умолчанию: ' . $lang['ACP_RH_TOPICTAGS_REGEX_DEFAULT'],

	'TOPICTAGS_CONVERT_SPACE_TO_MINUS'			=> 'Преобразование " " в "-"',
	'TOPICTAGS_CONVERT_SPACE_TO_MINUS_EXP'		=> 'Если установлено "Да", все пробелы (" ") автоматически заменяются знаком тире ("-").<br/>ПРИМЕЧАНИЕ 1: В регулярном выражении необходимо разрешить "-"; в противном случае теги с пробелами будут отклонены.<br/>ПРИМЕЧАНИЕ 2: Существующие теги с пробелами не будут преобразованы автоматически.',

	'TOPICTAGS_ALLOWED_TAGS_EXP_FOR_USERS'		=> 'Объяснение для пользователей',
	'TOPICTAGS_ALLOWED_TAGS_EXP_FOR_USERS_EXP'	=> 'Этот текст отображается для пользователей и объясняет, какие теги разрешены, а какие нет.<br/>По умолчанию: ' . $lang['ACP_RH_TOPICTAGS_REGEX_EXP_FOR_USERS_DEFAULT'],
	
	'TOPICTAGS_MANAGE_TAGS_EXP'					=> 'В таблице показаны все существующие теги. Здесь вы можете удалять их (и все их значения) или редактировать. Вы также можете объединять теги, изменив имя одного тега таким образом, что оно станет равным имени другого тега, в этом случае они будут объединены автоматически.',
	'TOPICTAGS_NO_TAGS'							=> 'Теги еще не были созданы.',
	'TOPICTAGS_TAG'								=> 'Тег',
	'TOPICTAGS_ASSIGNMENTS'						=> 'Значения',
	'TOPICTAGS_CREATE_TAG'						=> 'Создать новый тег',
	'TOPICTAGS_TAG_DELETE_CONFIRM'				=> "Вы подтверждаете удаление тега <em>%s</em>? Это действие удалит тег из <b>всех тем</b> где он определен. После выполнения удаления отмена не возможно.",
	'TOPICTAGS_TAG_DELETED'						=> 'Тег был удален.',
	'TOPICTAGS_MISSING_TAG_ID'					=> 'Отсутствует ID тега.',
	'TOPICTAGS_TAG_CHANGED'						=> 'Тег был изменен.',
	'TOPICTAGS_TAG_MERGED'						=> "Выбранный тег был объединен с тегом '%s'.",
	'TOPICTAGS_MISSING_TAG_NAMES'				=> 'Отсутствует имя тега.',
	'TOPICTAGS_TAG_INVALID'						=> 'Данный тег "%s" неверен, проверьте ваши настройки для тегов.',
	'TOPICTAGS_TAG_DOES_NOT_EXIST'				=> 'Тег "%s" не существует.',

));

