<?php
/**
*
* @package SEO Images in Attachment
* @copyright (c) 2014 Anvar
* @link http://bb3.mobi
* @license http://opensource.org/licenses/gpl-2.0.php GNU General Public License v2
*
*/

namespace bb3mobi\seoimg\event;

use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class listener implements EventSubscriberInterface
{

	static public function getSubscribedEvents()
	{
		return array(
			'core.parse_attachments_modify_template_data' => 'parse_attachments_modify_template_data',
		);
	}

	public function parse_attachments_modify_template_data($event)
	{
		global $topic_data;

		switch ($event['display_cat'])
		{
			// Images
			case ATTACHMENT_CATEGORY_IMAGE:
				if (!empty($event['attachment']['attach_comment']) || !empty($topic_data['topic_title']))
				{
					$attach_comment = $event['attachment']['attach_comment'];
					$attach_comment = ($attach_comment) ? $event['attachment']['attach_comment'] : $topic_data['topic_title'];
					$attach_comment = strip_tags(htmlspecialchars_decode($attach_comment));
					$attach_comment = str_replace(array('"', "'", "[", "]", "/"), "", $attach_comment);
					$attach_comment .= ' - ' . utf8_basename($event['attachment']['real_filename']);

					$inline_link = generate_board_url() ."/small/{$event['attachment']['attach_id']}.{$event['attachment']['extension']}";
					$download_link = generate_board_url() ."/img/{$event['attachment']['attach_id']}.{$event['attachment']['extension']}";
					$block_array = $event['block_array'];
					$block_array = array_merge($block_array, array(
						'DOWNLOAD_NAME'		=> $attach_comment,
						'U_INLINE_LINK'		=> $inline_link,
						'U_DOWNLOAD_LINK'	=> $download_link,)
					);
					$event['block_array'] = $block_array;
				}
			break;

			// Images, but display Thumbnail
			case ATTACHMENT_CATEGORY_THUMB:

				if (!empty($event['attachment']['attach_comment']) || !empty($topic_data['topic_title']))
				{
					$attach_comment = $event['attachment']['attach_comment'];
					$attach_comment = ($attach_comment) ? $event['attachment']['attach_comment'] : $topic_data['topic_title'];
					$attach_comment = strip_tags(htmlspecialchars_decode($attach_comment));
					$attach_comment = str_replace(array('"', "'", "[", "]", "/"), "", $attach_comment);
					$attach_comment .= ' - ' . utf8_basename($event['attachment']['real_filename']);

					$thumbnail_link = generate_board_url() ."/thumb/{$event['attachment']['attach_id']}.{$event['attachment']['extension']}";
					$download_link = generate_board_url() ."/pic/{$event['attachment']['attach_id']}.{$event['attachment']['extension']}";

					$block_array = $event['block_array'];
					$block_array = array_merge($block_array, array(
						'DOWNLOAD_NAME'		=> $attach_comment,
						'THUMB_IMAGE'		=> $thumbnail_link,
						'U_DOWNLOAD_LINK'	=> $download_link,)
					);
					$event['block_array'] = $block_array;
				}
			break;
		}
	}
}

?>